"""Configuration settings for Aera Risk Detection System"""
import os
from pathlib import Path
from dotenv import load_dotenv

ROOT_DIR = Path(__file__).parent
load_dotenv(ROOT_DIR / '.env')

class Settings:
    # Database (MySQL)
    DATABASE_URL: str = os.environ.get('DATABASE_URL', 'mysql+aiomysql://root:password@localhost/aera_db')
    
    # JWT
    JWT_SECRET: str = os.environ.get('JWT_SECRET', 'super-secret-key')
    JWT_ALGORITHM: str = os.environ.get('JWT_ALGORITHM', 'HS256')
    ACCESS_TOKEN_EXPIRE_MINUTES: int = int(os.environ.get('ACCESS_TOKEN_EXPIRE_MINUTES', 30))
    REFRESH_TOKEN_EXPIRE_DAYS: int = int(os.environ.get('REFRESH_TOKEN_EXPIRE_DAYS', 7))
    
    # Microsoft Graph API (Updated to match new Service)
    AZURE_TENANT_ID: str = os.environ.get('AZURE_TENANT_ID', os.environ.get('MS_TENANT_ID', ''))
    AZURE_CLIENT_ID: str = os.environ.get('AZURE_CLIENT_ID', os.environ.get('MS_CLIENT_ID', ''))
    AZURE_CLIENT_SECRET: str = os.environ.get('AZURE_CLIENT_SECRET', os.environ.get('MS_CLIENT_SECRET', ''))
    
    # AI
    ANTHROPIC_API_KEY: str = os.environ.get('ANTHROPIC_API_KEY', '')
    
    # Application
    MOCK_MODE: bool = os.environ.get('MOCK_MODE', 'true').lower() == 'true'
    CORS_ORIGINS: str = os.environ.get('CORS_ORIGINS', '*')

settings = Settings()