import React from 'react';
import { useAuth } from '../lib/api';
import { DashboardLayout } from '../components/DashboardLayout';
import { ChatbotWidget } from '../components/ChatbotWidget';
import { Settings, User, Shield, Bell, Database, Info } from 'lucide-react';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '../components/ui/card';
import { Badge } from '../components/ui/badge';
import { Separator } from '../components/ui/separator';
import { Switch } from '../components/ui/switch';
import { Label } from '../components/ui/label';

const SettingsPage = () => {
  const { user } = useAuth();

  return (
    <DashboardLayout title="Settings">
      <div className="grid gap-6 lg:grid-cols-2">
        {/* Profile Card */}
        <Card className="border shadow-sm">
          <CardHeader>
            <CardTitle className="font-['Manrope'] flex items-center gap-2">
              <User className="h-5 w-5 text-slate-500" />
              Profile
            </CardTitle>
            <CardDescription>Your account information</CardDescription>
          </CardHeader>
          <CardContent className="space-y-4">
            <div className="flex items-center gap-4">
              <div className="flex h-16 w-16 items-center justify-center rounded-full bg-slate-100">
                <User className="h-8 w-8 text-slate-600" />
              </div>
              <div>
                <h3 className="font-semibold text-slate-900">{user?.full_name}</h3>
                <p className="text-sm text-slate-500">{user?.email}</p>
              </div>
            </div>
            <Separator />
            <div className="grid grid-cols-2 gap-4 text-sm">
              <div>
                <p className="text-slate-500">Role</p>
                <Badge variant="outline" className="mt-1">
                  {user?.role}
                </Badge>
              </div>
              <div>
                <p className="text-slate-500">Status</p>
                <Badge variant="outline" className="mt-1 bg-green-50 text-green-700 border-green-200">
                  Active
                </Badge>
              </div>
            </div>
          </CardContent>
        </Card>

        {/* System Info Card */}
        <Card className="border shadow-sm">
          <CardHeader>
            <CardTitle className="font-['Manrope'] flex items-center gap-2">
              <Info className="h-5 w-5 text-slate-500" />
              System Information
            </CardTitle>
            <CardDescription>About this installation</CardDescription>
          </CardHeader>
          <CardContent className="space-y-4">
            <div className="grid gap-3 text-sm">
              <div className="flex justify-between">
                <span className="text-slate-500">Version</span>
                <span className="font-medium">1.0.0</span>
              </div>
              <Separator />
              <div className="flex justify-between">
                <span className="text-slate-500">AI Model</span>
                <span className="font-medium">Claude 3.5 Sonnet</span>
              </div>
              <Separator />
              <div className="flex justify-between">
                <span className="text-slate-500">Data Source</span>
                <Badge variant="outline" className="bg-blue-50 text-blue-700 border-blue-200">
                  Mock Mode
                </Badge>
              </div>
              <Separator />
              <div className="flex justify-between">
                <span className="text-slate-500">Database</span>
                <span className="font-medium">MongoDB</span>
              </div>
            </div>
          </CardContent>
        </Card>

        {/* Notifications Card */}
        <Card className="border shadow-sm">
          <CardHeader>
            <CardTitle className="font-['Manrope'] flex items-center gap-2">
              <Bell className="h-5 w-5 text-slate-500" />
              Notifications
            </CardTitle>
            <CardDescription>Configure alert preferences</CardDescription>
          </CardHeader>
          <CardContent className="space-y-4">
            <div className="flex items-center justify-between">
              <div>
                <Label htmlFor="high-risk-alerts" className="font-medium">
                  High Risk Alerts
                </Label>
                <p className="text-xs text-slate-500">Get notified for high-risk detections</p>
              </div>
              <Switch id="high-risk-alerts" defaultChecked />
            </div>
            <Separator />
            <div className="flex items-center justify-between">
              <div>
                <Label htmlFor="sync-notifications" className="font-medium">
                  Sync Notifications
                </Label>
                <p className="text-xs text-slate-500">Notify when sync completes</p>
              </div>
              <Switch id="sync-notifications" defaultChecked />
            </div>
            <Separator />
            <div className="flex items-center justify-between">
              <div>
                <Label htmlFor="email-digest" className="font-medium">
                  Daily Email Digest
                </Label>
                <p className="text-xs text-slate-500">Receive daily summary via email</p>
              </div>
              <Switch id="email-digest" />
            </div>
          </CardContent>
        </Card>

        {/* Security Card */}
        <Card className="border shadow-sm">
          <CardHeader>
            <CardTitle className="font-['Manrope'] flex items-center gap-2">
              <Shield className="h-5 w-5 text-slate-500" />
              Security
            </CardTitle>
            <CardDescription>Account security settings</CardDescription>
          </CardHeader>
          <CardContent className="space-y-4">
            <div className="flex items-center justify-between">
              <div>
                <Label className="font-medium">Two-Factor Authentication</Label>
                <p className="text-xs text-slate-500">Add an extra layer of security</p>
              </div>
              <Badge variant="outline" className="bg-slate-100 text-slate-600">
                Not Configured
              </Badge>
            </div>
            <Separator />
            <div className="flex items-center justify-between">
              <div>
                <Label className="font-medium">Session Timeout</Label>
                <p className="text-xs text-slate-500">Auto-logout after inactivity</p>
              </div>
              <span className="text-sm font-medium">30 minutes</span>
            </div>
            <Separator />
            <div className="flex items-center justify-between">
              <div>
                <Label className="font-medium">Password Last Changed</Label>
                <p className="text-xs text-slate-500">Update your password regularly</p>
              </div>
              <span className="text-sm text-slate-500">Never</span>
            </div>
          </CardContent>
        </Card>
      </div>

      <ChatbotWidget />
    </DashboardLayout>
  );
};

export default SettingsPage;
