# Aera - Centralized Risk Detection for Microsoft Teams

## Original Problem Statement
Build a centralized web portal for enterprise compliance and risk monitoring that:
- Securely ingests Microsoft Teams internal chats
- Uses AI (Claude) to detect sensitive, unethical, illegal, or policy-violating content
- Flags only medium and high-risk messages
- Allows compliance users to review, decide, and audit flagged conversations

## Architecture

### Technology Stack
- **Backend**: FastAPI (Python 3.11+), MongoDB (Motor async driver)
- **Frontend**: React, TailwindCSS, TanStack Query, Recharts
- **AI**: Anthropic Claude (claude-sonnet-4-20250514)
- **Auth**: JWT (python-jose, passlib)
- **Data Source**: Microsoft Graph API (with mock mode fallback)

### Core Components
1. **Sync Engine** - Fetches Teams conversations and analyzes with AI
2. **Claude Service** - Risk analysis with cross-chat context detection
3. **RAG Service** - Chatbot for querying risk data
4. **Dashboard** - Real-time stats, trends, and alerts
5. **Review Workflow** - Dismiss/Monitor/Escalate actions

## User Personas
1. **SuperAdmin** - Full access including audit logs
2. **Reviewer** - Can review and take actions on flagged messages
3. **Auditor** - Read-only access to audit trails

## Core Requirements (Static)
- [x] OAuth2 JWT authentication with refresh tokens
- [x] User registration for reviewers
- [x] MS Teams integration (Graph API) with mock mode
- [x] Claude AI risk detection
- [x] Cross-chat contradiction detection
- [x] Dashboard with real-time stats
- [x] Flagged messages list with filtering
- [x] Message review two-pane layout
- [x] Review actions (Dismiss/Monitor/Escalate)
- [x] RAG-lite chatbot
- [x] Audit logs (admin only)
- [x] Role-based access control

## What's Been Implemented (January 2026)

### Backend (/app/backend/)
- `server.py` - Main FastAPI app with all routes
- `config.py` - Environment configuration
- `database.py` - MongoDB connection and collections
- `models.py` - Pydantic models for all entities
- `auth.py` - JWT authentication utilities
- `services/` - Graph, Claude, RAG, Sync services
- `routers/` - Auth, Sync, Dashboard, Risks, Chatbot, Audit

### Frontend (/app/frontend/src/)
- Pages: Login, Register, Dashboard, FlaggedMessages, MessageReview, AuditLogs, Settings
- Components: DashboardLayout, Sidebar, ChatbotWidget, ProtectedRoute
- API client with auth context and React Query integration

### Key Features Working
1. Login/Register with JWT
2. Sync Teams button fetches mock conversations
3. Claude AI analyzes and flags 4 high-risk conversations
4. Cross-chat contradiction detected (Aniket told manager "deployment successful" but colleague "deleted prod DB")
5. Chatbot responds to risk queries
6. Review workflow with action buttons
7. Dashboard shows real-time stats and trends

## Prioritized Backlog

### P0 (Critical)
- None remaining

### P1 (High)
- [ ] Email notifications for high-risk alerts
- [ ] Real MS Graph API integration (disable mock mode)
- [ ] Bulk review actions

### P2 (Medium)
- [ ] Export reports to PDF/CSV
- [ ] Scheduled sync (cron job)
- [ ] Advanced filtering by date range
- [ ] User management UI for admins

## Next Tasks
1. Configure Azure AD for real MS Graph API access
2. Add email notifications for critical risks
3. Implement scheduled sync with background tasks
4. Add export functionality

## Demo Credentials
- Admin: admin@aera.com / Admin123!
- Reviewer: reviewer@aera.com / Reviewer123!

## Mock Mode
Set `MOCK_MODE=true` in backend/.env to use demo data without Azure AD setup.
